<?php

/**
 * return number of published sticky posts
 */
function get_sticky_posts_count() {
	 global $wpdb;
	 $sticky_posts = array_map( 'absint', (array) get_option('sticky_posts') );
	 return count($sticky_posts) > 0 ? $wpdb->get_var($wpdb->prepare("SELECT COUNT( 1 ) FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' AND ID IN (%s)", implode(',', $sticky_posts))) : 0;
}

/**
 * Get related posts
 *
 * @params $post_id (optional). If not passed, it will try to get global $post
 */
if(!function_exists('cactus_get_related_posts')){
	function cactus_get_related_posts( $options = array() ) 
	{
		if($options['enable_yarpp_plugin'] == 'on' && is_plugin_active('yet-another-related-posts-plugin/yarpp.php'))
		{
		    $related_posts =  yarpp_get_related(array('limit' => $options['related_post_limit'], 'post_type' => 'post'), $options['post_ID']);
		}
		else
		{
		    $args = array(
		        'post_type'             => 'post',
		        'posts_per_page'        => $options['related_post_limit'],
		        'orderby'               => $options['get_related_order_by'],
		        'post_status'           => 'publish',
		        'post__not_in'          => array($options['post_ID']),
		        'ignore_sticky_posts'   => true
		    );

		    if($options['get_related_post_by'] != '' && $options['get_related_post_by'] == 'cat')
		    {
		        //get categories of post
		        $categories =  get_the_category($options['post_ID']);
		        $cats       = array();
		        if(count($categories) > 0)
		        {
		            foreach($categories as $category)
		            {
		                $cats[] = $category->term_id;
		            }
		            $cats_str = implode(",",$cats);
		            $args['cat'] = $cats_str;
		        }
		    }
		    else if($options['get_related_post_by'] != '' && $options['get_related_post_by'] == 'tag')
		    {
		        $tags       = wp_get_post_tags($options['post_ID']);
		        $tags_arr   = array();
		        if(count($tags) > 0)
		        {
		            foreach($tags as $tag)
		            {
		                $tags_arr[] = $tag->term_id;
		            }
		            $args['tag__in'] = $tags_arr;
		        }
		    }

		    $related_post_query = new WP_Query( $args );
		    $related_posts      = $related_post_query->posts;
		}
		return $related_posts;
	}
}
if(!function_exists('cactus_get_posts')){
	/*
	 * Get item for trending, popular
	 * $conditions : most by :view, comment, likes, latest, rand/random
	 * $number : Number of post
	 * $ids : List id
	 */
	function cactus_get_posts($post_type, $conditions, $tags, $number, $ids,$sort_by, $categories, $args = array(), $trending, $timerange, $paged){

		if($trending ==''){$trending =0;}
		$args = '';
		if($conditions != 'featured')
		{
			if($trending ==1){
				if(isset($ids) && $ids == '')
				{
					if($conditions=='most_liked'){
						global $wpdb;
						if($timerange=='day'){$time_range='1';}
						else if($timerange=='week'){$time_range='7';}
						else if($timerange=='month'){$time_range='1m';}
						else if($timerange=='year'){$time_range='1y';}
						$order_by = 'ORDER BY like_count DESC, post_title';
						$limit = $where ='';
						if($number > 0) {
							$limit = "LIMIT " . $number;
						}

						$show_excluded_posts = get_option('wti_like_post_show_on_widget');
						$excluded_post_ids = explode(',', get_option('wti_like_post_excluded_posts'));

						if(!$show_excluded_posts && count($excluded_post_ids) > 0) {
							$where .= "AND post_id NOT IN (" . get_option('wti_like_post_excluded_posts') . ")";
						}

						if($timerange != 'all') {
							if(function_exists('GetWtiLastDate')){
								$last_date = GetWtiLastDate($time_range);
								$where .= " AND date_time >= '$last_date'";
							}
						}

						$query = "SELECT post_id, SUM(value) AS like_count, post_title FROM `{$wpdb->prefix}wti_like_post` L, {$wpdb->prefix}posts P ";
						$query .= "WHERE L.post_id = P.ID AND post_status = 'publish' AND value > 0 $where GROUP BY post_id $order_by $limit";
						$posts = $wpdb->get_results($query);
						$p_data = array();
						if(count($posts) > 0) {
							foreach ($posts as $post) {
								$p_data[] = $post->post_id;
							}
						}

						$args = array(
							'post_type' => $post_type,
							'posts_per_page' => $number,
							'orderby'=> 'post__in',
							'order' => 'ASC',
							'post_status' => 'publish',
							'tag' => $tags,
							'post__in' =>  $p_data,
							'ignore_sticky_posts' => 1
						);

					}else if($conditions=='most_viewed' || $conditions==''){
						if($timerange=='day')
						{
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'meta_key' => '_count-views_day-'.date("Ymd"),
								'orderby' => 'meta_value_num',
								'order' => 'DESC',
								'post_status' => 'publish',
							);
						}else
						if($timerange=='week')
						{
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'meta_key' => '_count-views_week-'.date("YW"),
								'orderby' => 'meta_value_num',
								'order' => '',
								'post_status' => 'publish',
							);
						}else
						if($timerange=='month')
						{
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'meta_key' => '_count-views_month-'.date("Ym"),
								'orderby' => 'meta_value_num',
								'order' => '',
								'post_status' => 'publish',
							);
						}else
						if($timerange=='year')
						{
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'meta_key' => '_count-views_year-'.date("Y"),
								'orderby' => 'meta_value_num',
								'order' => '',
								'post_status' => 'publish',
							);
						}else{
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'meta_key' => '_count-views_all',
								'orderby' => 'meta_value_num',
								'order' => '',
								'post_status' => 'publish',
							);
						}
					}else if($conditions=='most_commented'){
						wp_reset_postdata();
						if($timerange=='all'){
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'orderby' => 'comment_count',
								'order' => $sort_by,
								'post_status' => 'publish',
								'tag' => $tags
							);
						}else{
							if($timerange=='day'){
								$some_comments = get_comments( array(
									'date_query' => array(
										array(
											'after' => '1 day ago',
										),
									),
								) );
							}else
							if($timerange=='week'){
								$some_comments = get_comments( array(
									'date_query' => array(
										array(
											'after' => '1 week ago',
										),
									),
								) );
							}else
							if($timerange=='month'){
								$some_comments = get_comments( array(
									'date_query' => array(
										array(
											'after' => '1 month ago',
										),
									),
								) );
							}else
							if($timerange=='year'){
								$some_comments = get_comments( array(
									'date_query' => array(
										array(
											'after' => '1 year ago',
										),
									),
								) );
							}
							$arr_id= array();
							foreach($some_comments as $comment){
								$arr_id[] = $comment->comment_post_ID;
							}
							$arr_id = array_unique($arr_id, SORT_REGULAR);
							$args = array(
								'post_type' => 'post',
								'posts_per_page' => $number,
								'order' => $sort_by,
								'post_status' => 'publish',
								'post__in' =>  $arr_id,
								'ignore_sticky_posts' => 1,
							);
						}
					}else{
						$args = array(
							'post_type' => 'post',
							'posts_per_page' => $number,
							'order' => $sort_by,
							'post_status' => 'publish',
							'tag' => $tags,
							'ignore_sticky_posts' => true);
							if($timerange!='all'){
								if($timerange=='week'){$number_day ='7';
								}elseif($timerange=='day'){$number_day ='1';}
								elseif($timerange=='month'){$number_day ='30';}
								elseif($timerange=='year'){$number_day='365';}
								$limit_date =  date('Y-m-d', strtotime('-' . $number_day . ' day'));
								$args['date_query'] = array(
										'after'         => $limit_date
								);
							}
					}
					if($paged){$args['paged'] = $paged;}

					if(!is_array($categories)) {
						if(isset($categories)){
							$cats = explode(",",$categories);
							if(is_numeric($cats[0])){
								$args['category__in'] = $cats;
							}else{
								$args['category_name'] = $categories;
							}
						}
					}else if(count($categories) > 0){
						$args += array('category__in' => $categories);
					}
				}
				else
				{
					$args = array(
						'post_type' 			=> 'post',
						'posts_per_page' 		=> $number,
						'orderby' 				=> 'post__in',
						'post_status' 			=> 'publish',
						'ignore_sticky_posts' 	=> true
					);
					$id_arr = explode(",",$ids);
					if(is_numeric($id_arr[0]))
						$args['post__in'] = $id_arr;
				}

				$query = new WP_Query($args);

				if(!$query->have_posts())
				{
					unset($args['date_query']);
					$query = new WP_Query($args);
				}
				return $query;
			}else{
				if($conditions=='most_viewed' && $ids==''){
					  $args = array(
						  'post_type' => 'post',
						  'posts_per_page' => $number,
						  'meta_key' => '_count-views_all',
						  'orderby' => 'meta_value_num',
						  'order' => $sort_by,
						  'post_status' => 'publish',
						  'tag' => $tags,
						  'ignore_sticky_posts' => 1
					  );

				}elseif($conditions=='most_commented' && $ids==''){
					$args = array(
						'post_type' => 'post',
						'posts_per_page' => $number,
						'orderby' => 'comment_count',
						'order' => $sort_by,
						'post_status' => 'publish',
						'tag' => $tags
						);

				}elseif($conditions=='high_rated' && $ids==''){
					$args = array(
						'post_type' => 'post',
						'posts_per_page' => $number,
						'meta_key' => '_count-views_all',
						'orderby' => 'meta_value_num',
						'order' => $sort_by,
						'post_status' => 'publish',
						'tag' => $tags,
						'ignore_sticky_posts' => 1
						);
				} elseif($ids!=''){
					$ids = explode(",", $ids);
					$gc = array();
					$dem=0;
					foreach ( $ids as $grid_cat ) {
						$dem++;
						array_push($gc, $grid_cat);
					}
					$args = array(
						'post_type' => 'post',
						'posts_per_page' => $number,
						'order' => 'post__in',
						'post_status' => 'publish',
						'tag' => $tags,
						'post__in' =>  $gc,
						'ignore_sticky_posts' => 1);

				} elseif($ids=='' && $conditions=='latest'){
					$args = array(
						'post_type' => 'post',
						'posts_per_page' => $number,
						'order' => $sort_by,
						'post_status' => 'publish',
						'tag' => $tags,
						'ignore_sticky_posts' => 1);

				} elseif($ids=='' && $conditions=='most_liked'){
					global $wpdb;
					$time_range = 'all';
					$order_by = 'ORDER BY like_count DESC, post_title';
					$show_excluded_posts = get_option('wti_like_post_show_on_widget');
					$excluded_post_ids = explode(',', get_option('wti_like_post_excluded_posts'));

					if(!$show_excluded_posts && count($excluded_post_ids) > 0) {
						$where = "AND post_id NOT IN (" . get_option('wti_like_post_excluded_posts') . ")";
					}
					else{$where = '';}
					$query = "SELECT post_id, SUM(value) AS like_count, post_title FROM `{$wpdb->prefix}wti_like_post` L, {$wpdb->prefix}posts P ";
					$query .= "WHERE L.post_id = P.ID AND post_status = 'publish' AND value > -1 $where GROUP BY post_id $order_by";
					$posts = $wpdb->get_results($query);
					$p_data = array();
					if(count($posts) > 0) {
						foreach ($posts as $post) {
							$p_data[] = $post->post_id;
						}
					}

					$args = array(
						'post_type' => $post_type,
						'posts_per_page' => $number,
						'orderby'=> 'post__in',
						'order' => 'ASC',
						'post_status' => 'publish',
						'tag' => $tags,
						'post__in' =>  $p_data,
						'ignore_sticky_posts' => 1);
				} else {
					if($conditions == 'random') $conditions = 'rand';
					$args = array(
						'post_type' => $post_type,
						'posts_per_page' => $number,
						'order' => $sort_by,
						'orderby' => $conditions, /* title or modified */
						'post_status' => 'publish',
						'tag' => $tags,
						'ignore_sticky_posts' => 1);
				}
				if(!is_array($categories)) {
					if(isset($categories)){
						$cats = explode(",",$categories);
						if(is_numeric($cats[0])){
							$args['category__in'] = $cats;
						}else{
							$args['category_name'] = $categories;
						}
					}
				}else if(count($categories) > 0){
					$args += array('category__in' => $categories);
				}

				$query = new WP_Query($args);

				return $query;
			}
		}
		else
		{
			$options = array(
						'post_type' 			=> 'post',
						'posts_per_page' 		=> $number,
						'orderby' 				=> 'post_date',
						'post_status' 			=> 'publish',
						'ignore_sticky_posts' 	=> true
					);

			// if you don't setup post_ids param
			if(isset($ids) && $ids == '')
			{
				if(isset($categories) && $categories != '')
				{
					$cats = explode(",",$categories);
					if(is_numeric($cats[0]))
						$options['cat'] = $categories;
					else
						$options['category_name'] = $categories;
				}
				if(isset($tags) && $tags != '')
				{
					$options['tag'] = $tags;
				}
				$options['meta_query'] = array(array(
	                    'key'     => 'featured_post',
	                    'value'   => 'yes',
	                ),
	            );
			}
			else
			{
				$id_arr = explode(",",$ids);
				if(is_numeric($id_arr[0]))
					$options['post__in'] = $id_arr;
			}


			$query = new WP_Query($options);

			if(!$query->have_posts())
			{
				unset($options['meta_query']);
				$query = new WP_Query($options);
			}

			return $query;
		}
	}
}
//live comment
add_action( 'init', 'ajax_get_comment' );

function ajax_get_comment(){
	if(isset($_GET['ct_comment_wpnonce']) && wp_verify_nonce($_GET['ct_comment_wpnonce'], 'idn' . $_GET['id'])&&!is_admin()){
		$arr = array(
			'post_id' => $_GET['id'],
			'comment__not_in' => $_GET['idlist'],
			'number' => '-1',
			'date_query' => array(
				array(
					'year'  => date('Y', $_GET['dateim']),
					'month' => date('m', $_GET['dateim']),
					'day'   => date('d', $_GET['dateim']),
					'hour'   => date('h', $_GET['dateim']),
					'minute'   => date('i', $_GET['dateim']),
					'second'   => date('s', $_GET['dateim']),
					'compare'   => '>=',
				),
			),
		);
		$cm = get_comments($arr);
		wp_list_comments(array('style'=> 'ol','short_ping' => true,'avatar_size' => 50,),$cm);
		exit;
	}
}
//live comment
add_action( 'init', 'ajax_loadmorre_comment' );

function ajax_loadmorre_comment(){
	if(isset($_GET['cactus_load_cm']) && wp_verify_nonce($_GET['cactus_load_cm'], 'idn' . $_GET['id'])&&!is_admin()){
		$comments_per_page = get_option( 'comments_per_page' );
		$arr = array(
			'comment__not_in' => $_GET['idlist'],
			'post_id' => $_GET['id'],
			'order' => 'DESC',
			'number' => $comments_per_page,
			'offset' => ( ( ( (int)$_GET['page'] ) - 1 ) * ((int)$comments_per_page) ),
		);
		$cm = get_comments($arr);		
		wp_list_comments(array('style'=> 'ol','short_ping' => true,'avatar_size' => 50,),$cm);
		exit;
	}
}

//get content in live post
add_action( 'init', 'ajax_get_live_content' );

function ajax_get_live_content(){
	if(isset($_GET['cactus_load_live_content']) && wp_verify_nonce($_GET['cactus_load_live_content'], 'idn' . $_GET['id'])&&!is_admin())
	{
		$content_post = get_post($_GET['id']);
		$content = apply_filters('the_content', $content_post->post_content);
		$content_length = strlen($content);
		if($content_length != $_SESSION['content_length'])
		{
			echo do_shortcode($content);
			$_SESSION['content_length'] = $content_length;
		}
		exit;
	}
}

/**
 * get terms by its first letters
 *
 * @params
		$letter - string - a letter or '0-9'
		$taxonomy - string - name of taxonomy, ex: 'category' or 'post_tag'
   @return
		array - list of terms
 */
function newstube_get_terms_by_first_letter($letter, $taxonomy = 'category'){
	global $wpdb;
	
	if($letter == '0-9'){
		$where = array();
		for($i = 0; $i <= 9; $i++){
			array_push($where, "t1.`name` LIKE '$i%%'");
		}
		$where = implode(' OR ' , $where);
		$terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS t1, $wpdb->term_taxonomy AS t2 
										WHERE t1.`term_id` = t2.`term_id` AND t2.`taxonomy` = %s
												AND ($where)", $taxonomy));
	} else {
		$terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS t1, $wpdb->term_taxonomy AS t2 
										WHERE t1.`term_id` = t2.`term_id` AND t2.`taxonomy` = %s
												AND t1.`name` LIKE %s", $taxonomy, $letter . '%'));
	}
	return $terms;
}